# Assets Directory - Offline Support

This directory contains all CSS and JavaScript files needed for offline operation.

## Current Status

The application uses an **offline-first** approach:
- **Local files are tried first** - If a file exists locally, it will be used
- **CDN fallback** - If a local file doesn't exist, the application automatically falls back to CDN

## Required Files for Full Offline Support

To enable complete offline functionality, download the following files:

### DataTables CSS (Already downloaded ✓)
- ✅ `datatables/css/dataTables.bootstrap5.min.css`
- ✅ `datatables/buttons/css/buttons.bootstrap5.min.css`

### DataTables JS (Need to download)
- `datatables/js/jquery.dataTables.min.js` - https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js
- `datatables/js/dataTables.bootstrap5.min.js` - https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js
- `datatables/buttons/js/dataTables.buttons.min.js` - https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js
- `datatables/buttons/js/buttons.bootstrap5.min.js` - https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js
- `datatables/buttons/js/buttons.html5.min.js` - https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js
- `datatables/buttons/js/buttons.print.min.js` - https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js

### JSZip (Need to download)
- `jszip/jszip.min.js` - https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js

### PDFMake (Need to download)
- `pdfmake/pdfmake.min.js` - https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js
- `pdfmake/vfs_fonts.js` - https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js

## How to Download Files

### Option 1: Use the Download Script
Run from project root:
```bash
php download_assets.php
```

### Option 2: Manual Download
1. Create the directory structure if it doesn't exist
2. Download each file from the URLs above
3. Save them to the corresponding paths in this directory

### Option 3: Browser Download
1. Open each URL in your browser
2. Save the file (Ctrl+S or Right-click > Save As)
3. Place it in the correct directory

## How It Works

The `AssetHelper` class automatically:
1. Checks if a local file exists
2. Uses the local file if available
3. Falls back to CDN if the local file is missing

This ensures the application works both online and offline!
