# UI & Frontend Development

This project is for **UI and frontend development** using **Bootstrap 5** and **AdminLTE 4**.

## Assets (Offline-First)

All UI dependencies are in the `assets/` folder:

| Component | Purpose |
|-----------|--------|
| **Bootstrap 5** | `bootstrap.min.css`, `bootstrap.bundle.min.js` – layout, components, utilities |
| **AdminLTE 4** | `adminlte/css/`, `adminlte/js/` – admin dashboard layout, sidebar, cards |
| **Bootstrap Icons** | `bootstrap-icons.min.css`, `fonts/` – icon set |
| **jQuery** | `jquery.min.js` – required by AdminLTE & DataTables |
| **DataTables** | `datatables/` – sortable/searchable tables, export (Excel, PDF, Print) |
| **JSZip** | `jszip/jszip.min.js` – used by DataTables for Excel export |
| **PDFMake** | `pdfmake/` – used by DataTables for PDF export |

See `assets/README.md` for offline setup and CDN fallback.

---

## Projects

### 1. Automated Document Classification & Routing

**Purpose:** UI for an system that classifies incoming documents and routes them to the right department or workflow.

**Pages:**
- **Landing** – [landing.html](document-classification/landing.html) – Public landing page (hero, features, CTA)
- **Dashboard** – [index.html](document-classification/index.html) – Overview, stats, recent documents
- **Documents** – [documents.html](document-classification/documents.html) – List and manage documents (DataTables, export)
- **Upload** – [upload.html](document-classification/upload.html) – Drag-and-drop and batch upload; allowed file types; progress
- **Classification** – [classification.html](document-classification/classification.html) – Classification rules and categories
- **Routing** – [routing.html](document-classification/routing.html) – Routing rules and destinations
- **Pending** – [pending.html](document-classification/pending.html) – Pending / exceptions queue; classify or dismiss
- **Reports** – [reports.html](document-classification/reports.html) – Report list and entry point
- **Reports:** Documents by Category, Daily/Weekly Volume, Exceptions, Routing Performance

**Entry points:** Start at [document-classification/landing.html](document-classification/landing.html) or go to [document-classification/index.html](document-classification/index.html) for the app.

---

## Running Locally

Serve the project from a web server (e.g. XAMPP `htdocs`, or any static server).  
Open in browser: `http://localhost/ui/` (adjust host/path as needed).
