﻿using System;
using System.Text;

class PasswordGenerator
{
    static void Main()
    {
        Console.WriteLine("iNetTutor.com - Welcome to the Password Generator!");
        Console.Write("Enter the desired password length: ");
        int length = int.Parse(Console.ReadLine());

        Console.WriteLine("Select the character types to include:");
        Console.WriteLine("1. Uppercase letters");
        Console.WriteLine("2. Lowercase letters");
        Console.WriteLine("3. Digits");
        Console.WriteLine("4. Special characters");
        Console.WriteLine("Enter the options (e.g., 1234): ");
        string options = Console.ReadLine();

        string uppercaseLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        string lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        string digits = "0123456789";
        string specialCharacters = "!@#$%^&*()_+-=";

        StringBuilder password = new StringBuilder();
        Random random = new Random();

        while (password.Length < length)
        {
            if (options.Contains("1"))
                password.Append(uppercaseLetters[random.Next(uppercaseLetters.Length)]);

            if (options.Contains("2"))
                password.Append(lowercaseLetters[random.Next(lowercaseLetters.Length)]);

            if (options.Contains("3"))
                password.Append(digits[random.Next(digits.Length)]);

            if (options.Contains("4"))
                password.Append(specialCharacters[random.Next(specialCharacters.Length)]);
        }

        Console.WriteLine("Generated Password: " + password);
        Console.ReadKey();
    }
}