﻿using System;

namespace GradeComputation
{
    class Program
    {
        static void Main(string[] args)
        {
            // Initialize variables to store grades and weights
            double prelimGrade, midtermGrade, endTermGrade;
            double prelimWeight = 0.30, midtermWeight = 0.30, endTermWeight = 0.40;

            Console.WriteLine("Grade Computation Program");

            // Prompt and validate Prelim Grade
            prelimGrade = ValidateGrade("Prelim Grade");

            // Prompt and validate Midterm Grade
            midtermGrade = ValidateGrade("Midterm Grade");

            // Prompt and validate End Term Grade
            endTermGrade = ValidateGrade("End Term Grade");

            // Calculate the final grade
            double finalGrade = (prelimGrade * prelimWeight) +
                                (midtermGrade * midtermWeight) +
                                (endTermGrade * endTermWeight);

            // Display the final grade
            Console.WriteLine($"Your Final Grade is: {finalGrade:F2}");

            // Check if the final grade is a pass or fail
            if (finalGrade >= 75)
            {
                Console.WriteLine("Congratulations! You passed.");
            }
            else
            {
                Console.WriteLine("Sorry, you failed.");
            }

            Console.ReadLine(); // Keep the console window open
        }

        // method to check (input validation) if the user input is numeric
        static double ValidateGrade(string gradeType)
        {
            double grade;
            bool validInput = false;

            do
            {
                Console.Write($"Enter {gradeType}: ");
                if (double.TryParse(Console.ReadLine(), out grade))
                {
                    validInput = true;
                }
                else
                {
                    Console.WriteLine($"Invalid input for {gradeType}. Please enter a valid number.");
                }
            } while (!validInput);

            return grade;
        }
    }
}